



import os


from qgis.PyQt import uic, QtGui
from qgis.PyQt.QtCore import Qt, QPoint
from qgis.PyQt.QtWidgets import (
    QDialog, QToolButton, QStackedWidget, QWidget, QMessageBox
)


from urbanq.logging.logging_config import logger
from urbanq.function.qss import font_qss, selected_button_style, default_button_style


from urbanq.menu.license.license_dockwidget import licenseDockWidget
from urbanq.menu.timeSeries.timeSeries_dockwidget import timeSeriesDockWidget
from urbanq.menu.dataConversion.dataConversion_dockwidget import dataConversionDockWidget
from urbanq.menu.spatialAnalysis.spatialAnalysis_dockwidget import spatialAnalysisDockWidget
from urbanq.menu.mapVisualization.mapVisualization_dockwidget import mapVisualizationDockWidget


FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'urbanq_dialog_base.ui'))


class UrbanQDialog(QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        
        super(UrbanQDialog, self).__init__(parent)
        
        
        
        
        
        self.setupUi(self)

        
        self.setWindowIcon(QtGui.QIcon(":/plugins/urbanq/image/logo.png"))

        
        self.setWindowFlags(Qt.Window)

        
        self.setStyleSheet(font_qss)

        
        self.btnDataConversion.setProperty("class", "mediumText")
        self.btnMapVisualization.setProperty("class", "mediumText")
        self.btnSpatialAnalysis.setProperty("class", "mediumText")
        self.btnTimeSeries.setProperty("class", "mediumText")
        self.btnLicense.setProperty("class", "mediumText")

        
        self.selected_button_style = selected_button_style
        self.default_button_style = default_button_style

        
        
        self.menu_config = [
            ["btnDataConversion", "menu-dataConversion", "page_dataConversion", dataConversionDockWidget, None],
            ["btnMapVisualization", "menu-mapVisualization", "page_mapVisualization", mapVisualizationDockWidget, None],
            ["btnSpatialAnalysis", "menu-spatialAnalysis", "page_spatialAnalysis", spatialAnalysisDockWidget, None],
            ["btnTimeSeries", "menu-timeSeries", "page_timeSeries", timeSeriesDockWidget, None],
            ["btnLicense", "menu_license", "page_license", licenseDockWidget, None],
        ]

        
        self.set_button_icon_and_connect()

        
        self.btnLicense.click()

    
    def set_button_icon_and_connect(self):
        try:
            for index, (btn_name, icon_key, _, _, _) in enumerate(self.menu_config):
                btn = self.findChild(QToolButton, btn_name)
                if not btn:
                    continue

                
                btn.setProperty("page_index", index)

                
                btn.setIcon(QtGui.QIcon(f":/plugins/urbanq/image/{icon_key}.png"))

                
                btn.clicked.connect(self.update_button_and_page)

        except Exception as e:
            logger.error("에러 발생: %s", e, exc_info=True)

    
    def update_button_and_page(self):
        try:
            clicked_button = self.sender()
            if not clicked_button:
                return

            page_index = clicked_button.property("page_index")
            if page_index is None:
                return

            
            for idx, (btn_name, icon_key, _, _, _) in enumerate(self.menu_config):

                
                if idx in (1, 3):
                    continue

                btn = self.findChild(QToolButton, btn_name)
                if not btn:
                    continue

                if idx == page_index:
                    btn.setChecked(True)
                    btn.setIcon(QtGui.QIcon(f":/plugins/urbanq/image/{icon_key}_focus.png"))
                    btn.setStyleSheet(self.selected_button_style)
                else:
                    btn.setChecked(False)
                    btn.setIcon(QtGui.QIcon(f":/plugins/urbanq/image/{icon_key}.png"))
                    btn.setStyleSheet(self.default_button_style)

            
            self.load_menu_ui(page_index)
            self.stackedWidget.setCurrentIndex(page_index)

        except Exception as e:
            logger.error("에러 발생: %s", e, exc_info=True)

    
    def load_menu_ui(self, page_index):
        btn_name, icon_key, page_name, widget_class, cached_widget = self.menu_config[page_index]

        
        if cached_widget is not None:
            return

        
        widget_instance = widget_class(self)

        
        page = self.findChild(QWidget, page_name)

        
        layout = page.layout()
        if layout is None:
            layout.addWidget(widget_instance)

        
        layout.addWidget(widget_instance)

        
        self.menu_config[page_index][4] = widget_instance



